// ModifyIP.cpp : implementation file
//

#include "stdafx.h"
#include "rfidreader.h"
#include "ModifyIP.h"
#include "RFID.h"
#include "Progress.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif


C2000NETSETTING NS;
C2000SOCKETSETTING SS;
C2000COMSETTING CS;

/////////////////////////////////////////////////////////////////////////////
// CModifyIP dialog


CModifyIP::CModifyIP(CWnd* pParent /*=NULL*/)
	: CDialog(CModifyIP::IDD, pParent)
{
	//{{AFX_DATA_INIT(CModifyIP)
	//}}AFX_DATA_INIT
}


void CModifyIP::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CModifyIP)
	DDX_Control(pDX, IDC_EDITPort, m_ctlPort);
	DDX_Control(pDX, IDOK, m_btnOK);
	DDX_Control(pDX, IDCANCEL, m_btnCancel);
	DDX_Control(pDX, IDC_SubnetMask, m_ctlSubnetMask);
	DDX_Control(pDX, IDC_GateWay, m_ctlGateWay);
	DDX_Control(pDX, IDC_DNS, m_ctlDNS);
	DDX_Control(pDX, IDC_IPADDRESS, m_ctlIPAddress);
	DDX_Text(pDX, IDC_EDITPort, m_strPort);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CModifyIP, CDialog)
	//{{AFX_MSG_MAP(CModifyIP)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CModifyIP message handlers

void CModifyIP::OnOK() 
{
	// TODO: Add extra validation here
	CString DNS;
	CString GateWay;
	CString Mask;
	char *strMAC;
	CString strPort;

	strMAC = (LPSTR)(LPCTSTR)m_strMac;
	m_ctlIPAddress.GetWindowText(m_strNewIP);
	m_ctlSubnetMask.GetWindowText(Mask);
	m_ctlGateWay.GetWindowText(GateWay);
	m_ctlDNS.GetWindowText(DNS);
	memcpy(NS.ipAddr, m_strNewIP, m_strNewIP.GetLength() +1);
	memcpy(NS.ipNetMask, Mask, Mask.GetLength() +1);
	memcpy(NS.ipGateway, GateWay, GateWay.GetLength() +1);
	memcpy(NS.ipDnsServer, DNS, DNS.GetLength() +1);
	NS.bUseStaticIP = 1;
	m_ctlPort.GetWindowText(strPort);
	SS.nLocalPort = atoi(strPort);
	
	if ((SetC2000Setting(strMAC, &NS, 1, &SS, 1, &CS, 1, 1000) == FALSE) || \
		(ApplySetting(strMAC, 1000) == FALSE)) {
		MessageBox("Set IP Fail!", "Attention", MB_OKCANCEL | MB_ICONINFORMATION);
	}
	//MessageBox(NS.ipAddr, "Attention", MB_OKCANCEL | MB_ICONINFORMATION);

	CProgress dlg;
	dlg.DoModal();

	CDialog::OnOK();
}

void CModifyIP::OnCancel() 
{
	// TODO: Add extra cleanup here
	
	CDialog::OnCancel();
}

BOOL CModifyIP::OnInitDialog() 
{
	CDialog::OnInitDialog();
	
	// TODO: Add extra initialization here
	m_btnOK.SetThemeHelper(&m_ThemeHelper);
	m_btnCancel.SetThemeHelper(&m_ThemeHelper);
	m_ctlIPAddress.SetWindowText(m_strNewIP);
	m_ctlDNS.SetWindowText("0.0.0.0");
	m_ctlGateWay.SetWindowText("192.168.1.1");
	m_ctlSubnetMask.SetWindowText("255.255.255.0");
	//m_strPort = m_charPort;
	m_ctlPort.SetWindowText(m_charPort);
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}
